precision mediump float;

uniform sampler2D texture_diffuse;
uniform sampler2D texture_normal;
uniform sampler2D texture_albedo_normal_1;

varying vec4 v_colour;
varying vec2 v_uv;
varying vec2 v_screenpos;
varying vec3 v_normal;
varying vec3 v_tangent;

void main()
{
    vec4 light_col = texture2D( texture_diffuse, v_uv );// * v_colour;
    vec4 light_dir = ( texture2D( texture_normal, v_uv ) * 2.0 ) - 1.0;    
    vec4 normal    = texture2D( texture_albedo_normal_1,v_screenpos);
    
    float light_pwr    = light_col.r * v_colour.a;
    light_col          = light_col * v_colour;
    
    light_dir = vec4(-light_dir.x,-light_dir.y,light_dir.z,0.0);
   
    normal = (normal*2.0)-1.0;
    
    normal.xyz  = vec3(0.0,0.0,1.0) + normal.x * v_normal + normal.y * v_tangent;
    
    // Calculate lighting intensity            
    float lightIntensity = max(0.0,dot(normal.xyz,light_dir.xyz));          
    vec3 vLI = vec3(lightIntensity,lightIntensity,lightIntensity);
                   
    gl_FragColor  = vec4((vLI+light_col.xyz)*light_col.xyz,light_pwr);        
}
